<?php
/**
 * Display single product reviews (comments)
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product-reviews.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.7.0
 */

defined('ABSPATH') || exit;

global $product;

if (!comments_open()) {
	return;
}

$count = $product->get_review_count();

?>

<div id="reviews-holder">

	<div id="reviews" class="woocommerce-Reviews">

		<h2 class="woocommerce-Reviews-title">
			<?php
			$count = $product->get_review_count();
			if ($count && wc_review_ratings_enabled()) {
				/* translators: 1: reviews count 2: product name */
				$reviews_title = sprintf(esc_html(_n('%1$s Review for %2$s', '%1$s Reviews for %2$s', $count, 'calafate')), esc_html($count), '<span>' . get_the_title() . '</span>');
				echo apply_filters('woocommerce_reviews_title', $reviews_title, $count, $product); // WPCS: XSS ok.
			} else {
				esc_html_e('Reviews', 'calafate');
			}
			?>
		</h2>

		<?php if (get_option('woocommerce_enable_review_rating') === 'yes' && ($count = $product->get_review_count())): ?>

			<ol class="commentlist">
				<?php wp_list_comments(apply_filters('woocommerce_product_review_list_args', array('callback' => 'woocommerce_comments'))); ?>
			</ol>

			<?php if (get_comment_pages_count() > 1 && get_option('page_comments')):
				echo '<nav class="woocommerce-pagination">';
				paginate_comments_links(apply_filters('woocommerce_comment_pagination_args', array(
					'prev_text' => '&larr;',
					'next_text' => '&rarr;',
					'type' => 'list',
				)));
				echo '</nav>';
			endif; ?>

		<?php else: ?>

			<p class="woocommerce-noreviews">
				<?php esc_html_e('There are no reviews yet. Be the first one!', 'calafate'); ?></p>

		<?php endif; ?>

		<?php if (get_option('woocommerce_review_rating_verification_required') === 'no' || wc_customer_bought_product('', get_current_user_id(), $product->get_id())): ?>

			<div id="review_form_wrapper">
				<div id="review_form">
					<?php
					$commenter = wp_get_current_commenter();

					$comment_form = array(
						'title_reply' => '',
						'title_reply_to' => '',
						'title_reply_before' => '',
						'title_reply_after' => '',
						'comment_notes_after' => '',
						'fields' => array(
							'author' => '<p class="comment-form-author">' .
								'<input id="author" name="author" type="text" value="' . esc_attr($commenter['comment_author']) . '" required placeholder="' . esc_html__('Name', 'calafate') . '" /></p>',
							'email' => '<p class="comment-form-email">' .
								'<input id="email" name="email" type="email" value="' . esc_attr($commenter['comment_author_email']) . '" required placeholder="' . esc_html__('Email', 'calafate') . '" /></p>',
						),
						'label_submit' => esc_html__('Submit', 'calafate'),
						'logged_in_as' => '<p class="comment-logged-in-as">' . sprintf(wp_kses(__('You are logged in as %1$s.', 'calafate'), array('a' => array('href' => array()))), isset($user_identity) ? $user_identity : '') . '</p>', // WPCS: XSS OK.
						'comment_field' => '',
					);

					$account_page_url = wc_get_page_permalink('myaccount');
					if ($account_page_url) {
						/* translators: %s opening and closing link tags respectively */
						$comment_form['must_log_in'] = '<p class="must-log-in">' . sprintf(esc_html__('You must be %1$slogged in%2$s to post a review.', 'calafate'), '<a href="' . esc_url($account_page_url) . '">', '</a>') . '</p>';
					}

					if (get_option('woocommerce_enable_review_rating') === 'yes') {
						$comment_form['comment_field'] = '<p class="comment-form-rating"><select name="rating" id="rating" required>
								<option value="">' . esc_html__('Rate', 'calafate') . '</option>
								<option value="5">' . esc_html__('Perfect', 'calafate') . '</option>
								<option value="4">' . esc_html__('Good', 'calafate') . '</option>
								<option value="3">' . esc_html__('Average', 'calafate') . '</option>
								<option value="2">' . esc_html__('Not that bad', 'calafate') . '</option>
								<option value="1">' . esc_html__('Very Poor', 'calafate') . '</option>
							</select></p>';
					}

					$comment_form['comment_field'] .= '<p class="comment-form-comment"><textarea id="comment" name="comment" cols="45" rows="8" required placeholder="' . esc_html__('Your review', 'calafate') . '"></textarea></p>';

					comment_form(apply_filters('woocommerce_product_review_comment_form_args', $comment_form));
					?>
				</div>
			</div>

		<?php else: ?>

			<p class="woocommerce-verification-required">
				<?php esc_html_e('Only logged in customers who have purchased this product may leave a review.', 'calafate'); ?>
			</p>

		<?php endif; ?>

	</div>

</div>